<?php
namespace Tenweb_Builder\ElementorPro\Modules\Forms\Submissions\Data;

use Elementor\Data\Base\Controller as Controller_Base;
use Tenweb_Builder\ElementorPro\Modules\Forms\Submissions\Database\Entities\Form_Snapshot;
use Tenweb_Builder\ElementorPro\Modules\Forms\Submissions\Database\Repositories\Form_Snapshot_Repository;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Forms_Controller extends Controller_Base {
	public function get_name() {
		return 'twbb_forms';
	}

	public function get_items( $request ) {
		$forms = Form_Snapshot_Repository::instance()->all();

		// For now return only as "options"
		return [
			'data' => $forms->map(function ( Form_Snapshot $form ) {
				return [
					'label' => $form->get_label(),
					'value' => $form->get_key(),
				];
			})->values(),
			'meta' => [],
		];
	}

	public function register_endpoints() {
		//
	}

	protected function register_internal_endpoints() {
		// Register as internal to remove the default endpoint generated by the base controller.
		$this->register_endpoint( Endpoints\Forms_Index::class );
	}

	public function get_permission_callback( $request ) {
		return current_user_can( 'manage_options' );
	}
}
